<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/functions.php");

require_once('../vendor/autoload.php');

$result = array();

if(isset($_POST["quiz_id"]) && isset($_POST['questions_array'])) {
	
	$questions = $_POST["questions_array"];
	$quiz_id = $_POST["quiz_id"];
	
	// Check if the news exists
	$quiz_query = $dbh->prepare("SELECT id FROM quiz WHERE unique_id = :quiz_id");
	$quiz_query->bindParam(":quiz_id", $quiz_id);
	$quiz_query->execute();
	
	$nb_res_quizz = $quiz_query->rowCount();	
	
	if($nb_res_quizz > 0) {
		
		$quiz_infos = $quiz_query->fetch();
		$quiz_id = $quiz_infos["id"];
	
		if($_SESSION) {
			
			$email = $_SESSION["EMAIL"];
			
			$user_id = $_SESSION["USER_ID"];
			$good_replies_count = 0;
			$failed_replies_count = 0; 
			
			// List the questions
			foreach($questions as $question) {
				
				$question_id = $question["question_id"];
								
				// Get the right answers for this question
				$answers_query = $dbh->prepare("SELECT * FROM question_answers WHERE question_id = :question_id AND good = 1");
				$answers_query->bindParam(":question_id", $question_id);
				$answers_query->execute();
								
				$good_answers_array_id = array();
				
				while ($good_answer = $answers_query->fetch(PDO::FETCH_ASSOC)) {
					
					array_push($good_answers_array_id, $good_answer["id"]);
					
				}
				
				// Compare good with bad results
				if($good_answers_array_id == $question["answers"]) {
					$good_replies_count++;
				} else {
					$failed_replies_count++;
				}
			
				// Insert user's question's answer
				$stmt = $dbh->prepare("	INSERT INTO user_question_answers 
										SET 
										user_id = :user_id,
										quiz_id = :quiz_id,
										created_at = NOW(),
										question_id = :question_id,
										answers = :answers
										");
										
				$serialized_answers = serialize($question["answers"]);
									
				$stmt->bindParam(':answers', $serialized_answers);
				$stmt->bindParam(':quiz_id', $quiz_id);
				$stmt->bindParam(':user_id', $user_id);
				$stmt->bindParam(':question_id', $question_id);
				$stmt->execute();
				
			} 
			
			// Calculate success percent
			$percent = round(($good_replies_count*100)/sizeof($questions), 2);
			
			$unique_id = md5(uniqid($email . time(), true));
			
			// Insert a participation
			$stmt = $dbh->prepare("	INSERT INTO participation 
									SET 
									unique_id = :unique_id,
									user_id = :user_id,
									quiz_id = :quiz_id,
									created_at = NOW(),
									percent = :percent,
									nb_good = :nb_good,
									nb_wrong = :nb_wrong
									");
				
			$stmt->bindParam(':unique_id', $unique_id);				
			$stmt->bindParam(':quiz_id', $quiz_id);
			$stmt->bindParam(':user_id', $user_id);
			$stmt->bindParam(':percent', $percent);
			$stmt->bindParam(':nb_good', $good_replies_count);
			$stmt->bindParam(':nb_wrong', $failed_replies_count);
			$stmt->execute();
			
			$result["status"] = 1;
			$result["unique_id"] = $unique_id;
			$result["percent"] = $percent;
			$result["nb_wrong"] = $failed_replies_count;
			$result["nb_good"] = $good_replies_count;
			
		} else {
			
			$result["status"] = 0;
			$result["error"] = "Your session has expired. Please log-in again to continue...";
			
		}
	
	} else {
		
		$result["status"] = 0;
		$result["error"] = "Oops. Seems like this quiz doesn't exist anymore...";
		
	}
	
}

echo json_encode($result);
?>